OWC.socLocal = function() {
    var that = {};

    var ajaxServiceUrl = OWC.PROPERTIES.AJAX_SERVICE_URL;

    var socPageLoadComplete = function(userName, oclcNum, baseOclcNo, addTagsExpanded, addListsExpanded, userHasReviews)  {
        OWC.UTIL.log('socPageLoadComplete starting');
	if ((userName.length > 0) && (userHasReviews == 'true')) {
            // fill in the user's rating for this item (if they've rated it).
            OWC.UTIL.ajax(ajaxServiceUrl,
                       { serviceCommand: 'getUserReview',
                         itemId: baseOclcNo,
                         creatorId: userName 
                       },
                       function(data) {
                           OWC.UTIL.log("firing socPageLoadComplete callback");
                           if (data != "") {
                               var userReview = jQuery.parseJSON(data);
                               if (userReview != null)
                               {
                                   document.getElementById("soc-rev").href = "/oclc/" + oclcNum + "?page=newreview&oclcnum=" + baseOclcNo;
                                   document.getElementById("ratingLabel").innerHTML = "Your rating:";
                                   fillInRating(userReview.rating);

                                   if (userReview.hasDraft)
                                   {
                                       document.getElementById("soc-rev").innerHTML = "Your review (draft)";
                                       document.getElementById("soc-rev").title = "Continue editing your review";
                                       document.getElementById("rateRevPromptMsg").innerHTML = "You have a draft review for this item. Would you like to continue editing it?";
                                   }
                                   else if (userReview.hasPublished)
                                   {
                                       document.getElementById("soc-rev").innerHTML = "Your Review";
                                       document.getElementById("soc-rev").title = "Edit your review";
                                       document.getElementById("rateRevPromptMsg").innerHTML = "You have published a review for this item. Would you like to edit it also?";
                                   }
                               }
                           }
                       });
	}
	
	if (addTagsExpanded) {
	    jQuery('#soc-tag').click();
	}
	if (addListsExpanded) {
	    jQuery('#soc-list').click();
	}
    };
    that.socPageLoadComplete = socPageLoadComplete;

    var fillInRating = function(rating) 
    {
        var starList = document.getElementById("ratingStarList-socbar");
        if (rating == 0)      starList.className = "rating-small none-small";
        else if (rating == 1) starList.className = "rating-small one-small";
        else if (rating == 2) starList.className = "rating-small two-small";
        else if (rating == 3) starList.className = "rating-small three-small";
        else if (rating == 4) starList.className = "rating-small four-small";
        else if (rating == 5) starList.className = "rating-small five-small";

    };
    that.fillInRating = fillInRating;
    var myRating = "";
    var rated = false;

    var showRatingPromptDiv = function(canRate, rating) 
    {
        removeAllMessages();
        if (!canRate || rated)
        {
            $('cantRateDiv').style.display = 'block';
            $('ratingDoneDiv').style.display = 'none';
        }
        else
        {
            myRating = rating;
            $('ratingpromptDiv').style.display = 'block';
        }
    };
    that.showRatingPromptDiv = showRatingPromptDiv;

    var gotoNewReview = function(oclcNum, baseOclcNo, page) 
    {
        $('ratingpromptDiv').style.display = 'none';
        document.location.href = "/oclc/" + oclcNum + "?page=" + page + "&oclcnum="+ baseOclcNo + "&ratingchoice=" + myRating + "&client=worldcat.org-detailed_record";
        return false;
    };
    that.gotoNewReview = gotoNewReview;

    var gotoNewRating = function(authenticated, baseOclcNo) 
    {
        $('ratingpromptDiv').style.display = 'none';
	OWC.UTIL.ajax(ajaxServiceUrl,
                   { serviceCommand: 'doNewRating',
                     itemId: baseOclcNo, 
                     ratingchoice: myRating
                   },
                   function(data) {
		       var rateresp = jQuery.parseJSON(data);
                       if (rateresp.ratingsaved == "true")
                       {
                           $('cantRateDiv').style.display = 'none';
                           $('ratingDoneDiv').style.display = 'block';
                           if (authenticated)
                           {
                               rated = true;
                           }
                           else
                           {
                               fillInRating(myRating);
                           }
                       }
                       else if (rateresp.alreadyrated == "true")
                       {
                           $('cantRateDiv').style.display = 'block';
                           $('ratingDoneDiv').style.display = 'none';
                           rated = true;
                       }
	           });
        return false;
    };
    that.gotoNewRating = gotoNewRating;

    var removeAllMessages = function() 
    {
        //clear out any previous messages that might've been displayed
        $('cantRateDiv').style.display = 'none';
        $('ratingDoneDiv').style.display = 'none';
    };
    that.removeAllMessages = removeAllMessages;

    var loadaddtags = function(tagid) 
    {
        var value = document.getElementById('tags_'+tagid).innerHTML;
        var ctrl = document.getElementById('soc-tag-add');
        var text = ctrl.value;
        value = value.replace('&amp;','&');
        //value = value.replace('&amp','&');
        if(text == ""){
            text = text + trimAll(value);
        }
        else{
            text = text + "," + trimAll(value);
        }

        document.getElementById('soc-tag-add').value = text;
        var pos = ctrl.value.length;

        if(ctrl.setSelectionRange){
            ctrl.focus();
            ctrl.setSelectionRange(pos,pos);
        }else
            if (ctrl.createTextRange) {
                var range = ctrl.createTextRange();
                range.collapse(true);
                range.moveEnd('character', pos);
                range.moveStart('character', pos);
                range.select();
            }
        document.getElementById('soc-tag-add').focus();
    };
    that.loadaddtags = loadaddtags;

    var trimAll = function(sString)  {
        return sString.replace(/^\s*|\s*$/g,'');
    };
    that.trimAll = trimAll;

    var addTagsToItem = function() {
        var data = document.getElementById('soc-tag-add').value;

        // Remove all blanks from front and end (can't seem to find a trim() function)
        if (data.length > 0) {
            while(data.substr(0,1) == " ")
                 data = data.substr(1,data.length);
            while(data.substr(data.length - 1,1) == " ")
                data = data.substr(0,data.length - 1);
        }

        // Nothing left? display error
        if (data.length == 0) {
            document.getElementById('error_entertagsandapply').style.display = "block";
            return false;
        } else {
            // Remove the last comma
            if(data.substr(data.length - 1,1) == ",")
            data = data.substr(0,data.length - 1);
        }

        //    var legalChars = /^[\w|&|\-|'|\s|,]*$/; // include letters,digits,underscore,hyphen,ampersand,apostophe & Space
        var illegal = /[\.><?\/+=)(*^%#@!~`\:\;\[\]{}\\¡¿©®<>¢£"""«»°±¼½¾×÷???¤±¶§¬...º°]/;

	    var splitData = data.split(',');

        for(var i=0; i < splitData.length; i++){
	    while(splitData[i].substr(0,1) == " ")
                splitData[i] = splitData[i].substr(1,splitData[i].length);
            while(splitData[i].substr(splitData[i].length - 1,1) == " ")
                splitData[i] = splitData[i].substr(0,splitData[i].length - 1);
	    if(splitData[i].length <= 0 || splitData[i].length > 75){
		if(splitData[i].length > 75){
		    document.getElementById('savetagerror').style.display = "block";
		}
                else{
                    if(i==0){
                        document.getElementById('error_entertagsandapply').style.display = "block";
                    }else{
                        document.getElementById('error_oneemptytag').style.display = "block";
                    }
                }

                return false;
	    } else {
		if(splitData[i].match(illegal)){
		    document.getElementById('savetagerror').style.display = "block";
                    //				document.getElementById('confirm').style.display = "none";
		    return false;
		}
	    }
	}

	return true;
    };
    that.addTagsToItem = addTagsToItem;

    var doLoginForReview = function(oclcNum, baseOclcNo, rating) 
    {
        var redirect = "/oclc/" + oclcNum + "?page=newreview&oclcnum=" + baseOclcNo;
        if (rating > 0)
        {
            redirect += "&ratingchoice=" + rating;
        }
        showLoginPopupDiv('Write an online review',
                          'to write an online review.',
                          'https://lsulibraries.worldcat.org/account/' + oclcNum + '?page=login&redirect=' + redirect);
        return false;
    };
    that.doLoginForReview = doLoginForReview;

    var closeAddTagsButton = function() {
        dropdowncontent.hidediv('soc-tag-sub');
        document.getElementById('savetagerror').style.display='none';
        document.getElementById('error_entertagsandapply').style.display='none';
    };
    that.closeAddTagsButton = closeAddTagsButton;

    return that;
}();